const { app, ipcMain, BrowserWindow } = require('electron')
const path = require('path')
const isDevEnvironment = (__dirname.includes(".asar")) ? false : true

// Setup plugin
let pluginName = null; //put the right flash plugin in depending on the operating system.
let pluginPath = isDevEnvironment ? './' : '../';
switch (process.platform) {
	case 'win32':
		switch (process.arch) {
			case 'ia32':
			case 'x32':
				pluginName = pluginPath + 'plugins/pepflashplayer32_32_0_0_293.dll'
				console.log("Flash Player 32x32 plugined: ", pluginName);
				break
			case 'x64':
				pluginName = pluginPath + 'plugins/pepflashplayer64_32_0_0_293.dll'
				console.log("Flash Player 32x64 plugined: ", pluginName);
				break
		}
		break
	case 'linux':
		switch (process.arch) {
			case 'ia32':
			case 'x32':
				pluginName = pluginPath + 'plugins/libpepflashplayer.so' // added and tested :D
				break
			case 'x64':
				pluginName = pluginPath + 'plugins/libpepflashplayer.so'
				break
		}

		app.commandLine.appendSwitch('no-sandbox');
		break
	case 'darwin':
		pluginName = pluginPath + 'plugins/PepperFlashPlayer.plugin'
		break
}
app.commandLine.appendSwitch("disable-renderer-backgrounding");
if (process.platform !== "darwin") {
	app.commandLine.appendSwitch('high-dpi-support', "1");
}

app.commandLine.appendSwitch("--enable-npapi");
app.commandLine.appendSwitch('ppapi-flash-path', path.join(__dirname, pluginName));
app.commandLine.appendSwitch('disable-site-isolation-trials');
app.commandLine.appendSwitch('no-sandbox');
app.commandLine.appendSwitch('ignore-certificate-errors', 'true');
app.commandLine.appendSwitch('allow-insecure-localhost', 'true');

// Setup popup
const createModal = (htmlFile, parentWindow, width, height) => {
  let modal = new BrowserWindow({
    width: width,
    height: height,
    modal: true,
	devTools: true,
    parent: parentWindow,
    webPreferences: {
		plugins: true,
		nodeIntegration: true
    }
  })

  modal.loadURL(htmlFile)

  return modal;

}

// Setup primary window
function createWindow () {
		const { screen } = require('electron')	
		const primaryDisplay = screen.getPrimaryDisplay()
		const { width, height } = primaryDisplay.workAreaSize
		// Fix width/height of window
		const widthFixed = (width > 1336) ? 1336 : (width - 30);
		const heightFixed =  (height > 768) ? 768 : (height - 30);
		// window add options
		const win = new BrowserWindow({	
		width: widthFixed,
		height: heightFixed,
		devTools: isDevEnvironment, /* Debug only in dev environment (Ctr + Shift + I) press key*/
		frame:false,
		transparent: true,
		webPreferences: {
			plugins: true,
			nodeIntegration: true,
			contextIsolation: false,
			enableRemoteModule: true,
			preload: path.join(__dirname, 'preload.js')
		}
	})
	const globalShortcut = require('electron').globalShortcut
	// When use F5 press key
	globalShortcut.register('f5', function() {
		console.log('f5 is pressed')
		win.reload()
	})
	globalShortcut.register('CommandOrControl+R', function() {
			console.log('CommandOrControl+R is pressed')
			win.reload()
	})
	win.loadFile('./index.html')
	
	// Open new window
	win.webContents.on('new-window', function(e, url) {
		console.log('new-window URL: ', url);
		if(url.indexOf('?gclid=') != -1 || url.indexOf('&gclid=') != -1 || url.indexOf('lgplp=') != -1 || url.indexOf('googleadservices.com') != -1){
			console.log('openExternal: ', url);
			//console.log('event: ', e);
			e.preventDefault();
			// Open url on other browser
			require('electron').shell.openExternal(url);
		}else{
			console.log('createModal: ', url);
			e.preventDefault();
			// Open URL in FSG Browser
			createModal(url, win, widthFixed*90/100, heightFixed*80/100);
		}
	});
	
	ipcMain.on('goBack', async (event, arg) => {
		win.webContents.goBack()
		event.sender.send('WentBack', 'Done')
	})
	ipcMain.on('goForward', async (event, arg) => {
		win.webContents.goForward()
		event.sender.send('WentForward', 'Done')
	})
}

// Create main window
app.whenReady().then(() => {
  createWindow()

  app.on('activate', () => {
    if (BrowserWindow.getAllWindows().length === 0) {
      createWindow()
    }
  })
})

app.on('window-all-closed', () => {
  if (process.platform !== 'darwin') {
    app.quit()
  }
})