var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var debug = require("debug");
var path = require("path");
var spawn_1 = require("./spawn");
var helpers_1 = require("./helpers");
var d = debug('electron-notarize');
function startNotarize(opts) {
    return __awaiter(this, void 0, void 0, function () {
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    d('starting notarize process for app:', opts.appPath);
                    return [4 /*yield*/, helpers_1.withTempDir(function (dir) { return __awaiter(_this, void 0, void 0, function () {
                            var zipPath, zipResult, result, uuidMatch;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        zipPath = path.resolve(dir, path.basename(opts.appPath, '.app') + ".zip");
                                        d('zipping application to:', zipPath);
                                        return [4 /*yield*/, spawn_1.spawn('zip', [
                                                '-r',
                                                '-y',
                                                zipPath,
                                                path.basename(opts.appPath),
                                            ], {
                                                cwd: path.dirname(opts.appPath),
                                            })];
                                    case 1:
                                        zipResult = _a.sent();
                                        if (zipResult.code !== 0) {
                                            throw new Error("Failed to zip application, exited with code: " + zipResult.code + "\n\n" + zipResult.output);
                                        }
                                        d('zip succeeded, attempting to upload to apple');
                                        return [4 /*yield*/, spawn_1.spawn('xcrun', [
                                                'altool',
                                                '--notarize-app',
                                                '-f',
                                                zipPath,
                                                '--primary-bundle-id',
                                                opts.appBundleId,
                                                '-u',
                                                helpers_1.makeSecret(opts.appleId),
                                                '-p',
                                                helpers_1.makeSecret(opts.appleIdPassword),
                                            ])];
                                    case 2:
                                        result = _a.sent();
                                        if (result.code !== 0) {
                                            throw new Error("Failed to upload app to Apples notarization servers\n\n" + result.output);
                                        }
                                        d('upload success');
                                        uuidMatch = /\nRequestUUID = (.+?)\n/g.exec(result.output);
                                        if (!uuidMatch) {
                                            throw new Error("Failed to find request UUID in output:\n\n" + result.output);
                                        }
                                        d('found UUID:', uuidMatch[1]);
                                        return [2 /*return*/, {
                                                uuid: uuidMatch[1],
                                            }];
                                }
                            });
                        }); })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.startNotarize = startNotarize;
function waitForNotarize(opts) {
    return __awaiter(this, void 0, void 0, function () {
        var result, notarizationInfo;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    d('checking notarization status:', opts.uuid);
                    return [4 /*yield*/, spawn_1.spawn('xcrun', [
                            'altool',
                            '--notarization-info',
                            opts.uuid,
                            '-u',
                            helpers_1.makeSecret(opts.appleId),
                            '-p',
                            helpers_1.makeSecret(opts.appleIdPassword),
                        ])];
                case 1:
                    result = _a.sent();
                    if (result.code !== 0) {
                        throw new Error("Failed to check status of notarization request: " + opts.uuid + "\n\n" + result.output);
                    }
                    notarizationInfo = helpers_1.parseNotarizationInfo(result.output);
                    if (!(notarizationInfo.status === 'in progress')) return [3 /*break*/, 3];
                    d('still in progress, waiting 30 seconds');
                    return [4 /*yield*/, new Promise(function (r) { return setTimeout(r, 30000); })];
                case 2:
                    _a.sent();
                    return [2 /*return*/, waitForNotarize(opts)];
                case 3:
                    d('notarzation done with info:', notarizationInfo);
                    if (notarizationInfo.status === 'invalid') {
                        d('notarization failed');
                        throw new Error("Apple failed to notarize your application, check the logs for more info\n\nStatus Code: " + (notarizationInfo.statusCode || 'No Code') + "\nMessage: " + (notarizationInfo.statusMessage || 'No Message') + "\nLogs: " + notarizationInfo.logFileUrl);
                    }
                    if (notarizationInfo.status !== 'success') {
                        throw new Error("Unrecognized notarization status: \"" + notarizationInfo.status + "\"");
                    }
                    d('notarization was successful');
                    return [2 /*return*/];
            }
        });
    });
}
exports.waitForNotarize = waitForNotarize;
function stapleApp(opts) {
    return __awaiter(this, void 0, void 0, function () {
        var result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    d('attempting to staple app:', opts.appPath);
                    return [4 /*yield*/, spawn_1.spawn('xcrun', [
                            'stapler',
                            'staple',
                            '-v',
                            path.basename(opts.appPath),
                        ], {
                            cwd: path.dirname(opts.appPath),
                        })];
                case 1:
                    result = _a.sent();
                    if (result.code !== 0) {
                        throw new Error("Failed to staple your application with code: " + result.code + "\n\n" + result.output);
                    }
                    d('staple succeeded');
                    return [2 /*return*/];
            }
        });
    });
}
exports.stapleApp = stapleApp;
function notarize(_a) {
    var appBundleId = _a.appBundleId, appPath = _a.appPath, appleId = _a.appleId, appleIdPassword = _a.appleIdPassword;
    return __awaiter(this, void 0, void 0, function () {
        var uuid;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, startNotarize({
                        appBundleId: appBundleId,
                        appPath: appPath,
                        appleId: appleId,
                        appleIdPassword: appleIdPassword,
                    })];
                case 1:
                    uuid = (_b.sent()).uuid;
                    return [4 /*yield*/, waitForNotarize({ uuid: uuid, appleId: appleId, appleIdPassword: appleIdPassword })];
                case 2:
                    _b.sent();
                    return [4 /*yield*/, stapleApp({ appPath: appPath })];
                case 3:
                    _b.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.notarize = notarize;
//# sourceMappingURL=index.js.map